/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.hotfix;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.InvalidRefNameException;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.RestErrors;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;

public class RefNameFilter
implements Filter {
    private static final String PROJECT = "/projects/([a-zA-Z][a-zA-Z0-9_\\-]*)";
    private static final String REPOSITORY = "/repos/([\\p{Alnum}][\\w\\-\\.]*)";
    private static final String PREFIX_ALL = "(?:/mvc|/rest/api/latest|/rest/api/1.0)?/projects/([a-zA-Z][a-zA-Z0-9_\\-]*)/repos/([\\p{Alnum}][\\w\\-\\.]*)";
    private static final String PREFIX_MVC = "(?:/mvc)?/projects/([a-zA-Z][a-zA-Z0-9_\\-]*)/repos/([\\p{Alnum}][\\w\\-\\.]*)";
    private static final String PREFIX_REST = "(?:/rest/api/latest|/rest/api/1.0)/projects/([a-zA-Z][a-zA-Z0-9_\\-]*)/repos/([\\p{Alnum}][\\w\\-\\.]*)";
    static final Pattern PATTERN_BROWSE = Pattern.compile("(?:/mvc)?/projects/([a-zA-Z][a-zA-Z0-9_\\-]*)/repos/([\\p{Alnum}][\\w\\-\\.]*)/browse/?.*");
    static final Pattern PATTERN_CHANGES = Pattern.compile("(?:/rest/api/latest|/rest/api/1.0)/projects/([a-zA-Z][a-zA-Z0-9_\\-]*)/repos/([\\p{Alnum}][\\w\\-\\.]*)/changes/?$");
    static final Pattern PATTERN_COMMIT = Pattern.compile("(?:/mvc|/rest/api/latest|/rest/api/1.0)?/projects/([a-zA-Z][a-zA-Z0-9_\\-]*)/repos/([\\p{Alnum}][\\w\\-\\.]*)/commits/(([^/]+)/?.*)");
    static final Pattern PATTERN_COMMIT_CHANGES = Pattern.compile("(?:/rest/api/latest|/rest/api/1.0)/projects/([a-zA-Z][a-zA-Z0-9_\\-]*)/repos/([\\p{Alnum}][\\w\\-\\.]*)/commits/[^/]+/changes/?");
    static final Pattern PATTERN_COMMIT_DIFF = Pattern.compile("(?:/rest/api/latest|/rest/api/1.0)/projects/([a-zA-Z][a-zA-Z0-9_\\-]*)/repos/([\\p{Alnum}][\\w\\-\\.]*)/commits/[^/]+/diff/(?:.+)");
    static final Pattern PATTERN_COMMITS = Pattern.compile("(?:/mvc|/rest/api/latest|/rest/api/1.0)?/projects/([a-zA-Z][a-zA-Z0-9_\\-]*)/repos/([\\p{Alnum}][\\w\\-\\.]*)/commits/?");
    static final Pattern PATTERN_DIFF = Pattern.compile("(?:/mvc|/rest/api/latest|/rest/api/1.0)?/projects/([a-zA-Z][a-zA-Z0-9_\\-]*)/repos/([\\p{Alnum}][\\w\\-\\.]*)/diff/?.*");
    static final Pattern PATTERN_PULL_REQUEST_CHANGES = Pattern.compile("(?:/rest/api/latest|/rest/api/1.0)/projects/([a-zA-Z][a-zA-Z0-9_\\-]*)/repos/([\\p{Alnum}][\\w\\-\\.]*)/pull-requests/[\\d]+/changes/?");
    static final Pattern PATTERN_PULL_REQUEST_COMMIT = Pattern.compile("(?:/mvc)?/projects/([a-zA-Z][a-zA-Z0-9_\\-]*)/repos/([\\p{Alnum}][\\w\\-\\.]*)/pull-requests/[\\d]+/commits/(.+)$");
    static final Pattern PATTERN_PULL_REQUEST_DIFF = Pattern.compile("(?:/rest/api/latest|/rest/api/1.0)/projects/([a-zA-Z][a-zA-Z0-9_\\-]*)/repos/([\\p{Alnum}][\\w\\-\\.]*)/pull-requests/[\\d]+/diff/(?:.+)");
    static final String TYPE_JSON = "application/json";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final I18nService i18nService;
    private final RepositoryService repositoryService;

    public RefNameFilter(I18nService i18nService, RepositoryService repositoryService) {
        this.i18nService = i18nService;
        this.repositoryService = repositoryService;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        LinkedHashSet<String> candidates;
        Matcher matcher;
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        String uri = servletRequest.getPathInfo();
        if (uri == null) {
            uri = servletRequest.getServletPath();
        }
        if ((matcher = PATTERN_PULL_REQUEST_DIFF.matcher(uri)).matches() || (matcher = PATTERN_PULL_REQUEST_CHANGES.matcher(uri)).matches()) {
            candidates = new LinkedHashSet<String>();
            candidates.add(servletRequest.getParameter("untilId"));
            candidates.add(servletRequest.getParameter("sinceId"));
        } else {
            matcher = PATTERN_PULL_REQUEST_COMMIT.matcher(uri);
            if (matcher.matches()) {
                candidates = new LinkedHashSet();
                candidates.add(matcher.group(3));
                candidates.add(servletRequest.getParameter("since"));
            } else {
                matcher = PATTERN_BROWSE.matcher(uri);
                if (matcher.matches()) {
                    candidates = new LinkedHashSet();
                    candidates.add(servletRequest.getParameter("at"));
                    candidates.add(servletRequest.getParameter("until"));
                } else {
                    matcher = PATTERN_COMMITS.matcher(uri);
                    if (matcher.matches() || (matcher = PATTERN_CHANGES.matcher(uri)).matches() || (matcher = PATTERN_DIFF.matcher(uri)).matches()) {
                        candidates = new LinkedHashSet();
                        candidates.add(servletRequest.getParameter("until"));
                        candidates.add(servletRequest.getParameter("since"));
                        candidates.add(servletRequest.getParameter("at"));
                    } else {
                        matcher = PATTERN_COMMIT.matcher(uri);
                        if (matcher.matches()) {
                            candidates = new LinkedHashSet();
                            if (uri.startsWith("/rest/api/")) {
                                candidates.add(matcher.group(4));
                                if (PATTERN_COMMIT_DIFF.matcher(uri).matches() || PATTERN_COMMIT_CHANGES.matcher(uri).matches()) {
                                    candidates.add(servletRequest.getParameter("since"));
                                }
                            } else {
                                candidates.add(matcher.group(3));
                            }
                        } else {
                            filterChain.doFilter(request, response);
                            return;
                        }
                    }
                }
            }
        }
        String invalidRefName = candidates.stream().filter(Objects::nonNull).filter(commitId -> commitId.startsWith("-")).findFirst().orElse(null);
        if (invalidRefName == null || !this.isAccessible(matcher)) {
            filterChain.doFilter(request, response);
        } else {
            HttpServletResponse servletResponse = (HttpServletResponse)response;
            servletResponse.setStatus(400);
            servletResponse.setContentType(TYPE_JSON);
            try (PrintWriter writer = servletResponse.getWriter();
                 JsonGenerator generator = MAPPER.getJsonFactory().createJsonGenerator((Writer)writer);){
                InvalidRefNameException exception = new InvalidRefNameException(this.i18nService.createKeyedMessage("bitbucket.git.commandbuilder.invalidcommitish", new Object[]{invalidRefName}), invalidRefName);
                generator.writeObject((Object)new RestErrors((ServiceException)exception));
            }
            servletResponse.flushBuffer();
        }
    }

    public void init(FilterConfig filterConfig) {
    }

    private boolean isAccessible(Matcher matcher) {
        try {
            String key = matcher.group(1);
            String slug = matcher.group(2);
            return this.repositoryService.getBySlug(key, slug) != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

